/*==================================================
* Copyright: Shenzhen Tian Microelectronics
* File name: TM1637
* Current Version: 1.0
* SCM Model: AT89S52
* Development Environment: Keil uVision3
* Crystal earthquake frequency: 11.0592M
* Program features: the TM1637 all filled with all the display data register address
  0xff, and open the display, and then read the key value.
  
  ɥκ귽y[ק
  |88:88A^Ʀr|ܦbӦƦmC
===========================================================*/
   # include <reg52.h>
   # include <intrins.h>
   // Define port
   sbit clk = P1^3;
   sbit dio = P1^1;

 const unsigned char code seg_data[13] =
 {
     0x3F, // 0
     0x06, // 1
     0x5B, // 2
     0x4F, // 3
     0x66, // 4
     0x6D, // 5
     0x7D, // 6
     0x07, // 7
     0x7F, // 8
     0x6F, // 9 
     0x00, // none
     0x03, // :
     0x04  // .  
 }; 
 /*
  const unsigned char seg_addr[5] =
 {
     0xC0, // :
     0xC1, // 1st
     0xC2, // 2
     0xC3, // 3
     0xC4, // 4
 };
 */
//=======================================
void delay1ms()
	{
		TMOD = 0x01;    // Timer0 mode1
		TH0 = 0xFC; 	 //initial value for 1ms
		TL0 = 0x66;
		TR0 = 1;      // timer start
		while(TF0==0);  // check overflow condition
		TR0 = 0;     // Stop Timer
		TF0 = 0;    // Clear flag
	}
  
void delay_ms(int n)
	{
    int i;
    for(i=0; i<=n; i++)
	     delay1ms();
	}
//=======================================
void Delay_us (unsigned int i) // n us delay
{
   for (; i> 0; i--)
     nop_ ();
}
//======================================
void I2CStart (void) // 1637 start
{
   clk = 1;
   dio = 1;
   Delay_us (2);
   dio = 0;
}
//=============================================
void I2Cask (void) // 1637 Answer
{
   clk = 0;
   Delay_us (5); // After the falling edge of the eighth clock delay 5us, ACK signals the beginning of judgment
   while (dio);
   clk = 1;
   Delay_us (2);
   clk = 0;
}
//========================================
void I2CStop (void) // 1637 Stop
{
   clk = 0;
   Delay_us (2);
   dio = 0;
   Delay_us (2);
   clk = 1;
   Delay_us (2);
   dio = 1;
}
//=========================================
void I2CWrByte (unsigned char oneByte) // write a byte
{
   unsigned char i;
   for (i = 0; i <8; i++)
   {
      clk = 0;
      if (oneByte & 0x01)   // low front
        {dio = 1;}
      else 
        {dio = 0;}
      Delay_us (3);
      oneByte = oneByte >> 1;
      clk = 1;
      Delay_us (3);
   }
}
//----------------------------------------------- -
unsigned char ScanKey(void) // read buttons 
{
   unsigned char rekey, rkey, i;
   I2CStart ();
   I2CWrByte (0x42); // read command buttons
   I2Cask ();
   dio = 1; // read keys before data lines pulled
   for (i = 0; i <8; i++) // start reading from the low
   {
      clk = 0;
      rekey = rekey >> 1;
      Delay_us(30);
      clk=1;
      if(dio)
      {
          rekey=rekey|0x80;
      }
      else
      {
          rekey=rekey|0x00;
      }
      Delay_us(30);
   }
   I2Cask();
   I2CStop();
   return (rekey);
}

void SmgDisplay(void) // Write display register
{
   unsigned char i;
   I2CStart();
   I2CWrByte(0x40); //40H address is automatically incremented by 1 mode, 44H fixed address mode
   I2Cask();
   I2CStop();
   I2CStart();
   I2CWrByte(0xc0); // Set the first address
   I2Cask();
   for(i=0;i<4;i++) // Addresses from Canada, do not always write address
   {
      I2CWrByte(seg_data[i]); // Send data
      I2Cask();
   }
   I2CStop();
   I2CStart();
   I2CWrByte(0x8f); // Open display, maximum brightness
   I2Cask();
   I2CStop();
}
//-----------------------------------------------
void DisplayNum(int num[5]) // Write display register
{
   unsigned char i; 
   I2CStart();
   I2CWrByte(0x40); //40H address is automatically incremented by 1 mode, 44H fixed address mode
   I2Cask();
   I2CStop();
   I2CStart();
   I2CWrByte(0xC0); // Set the address, 0xC0 is first
   I2Cask();
   for(i=0;i<5;i++) // Addresses from Canada, do not always write address
   {
      I2CWrByte(seg_data[num[i]]); // Send data
      I2Cask();
   }
   I2Cask();
   I2CStop();
   I2CStart();
   I2CWrByte(0x8f); // Open display, maximum brightness
   I2Cask();
   I2CStop();
}
//==============================================
void init() // Initialization routine
{
   // Initialization slightly
}
//------------------------------------------------

//==============================================
void main(void)
{
    int num[5];
    unsigned char keydate;
    init(); // Initialization
    //SmgDisplay(); // Write register and open display
    
    num[0] = 11;
    num[1] = 8;
    num[2] = 8;
    num[3] = 8;
    num[4] = 8;
    DisplayNum(num);   //Nnum[]ƦrǵTN1637
  
    while(1)
    {
       keydate = ScanKey();  // Read key value, the key value is not read out for treatment.
       if(keydate != 0xFF)       
         if(keydate>=0xF0 && keydate<=0xF7)
           num[4] = keydate & 0x0F;
         else
           num[4] = 10;                
       
       DisplayNum(num);
       delay_ms(100);
      
    }
}
//===========end==================================